﻿//////////////////////////////////////////////
// MeshInputLayoutAttribute.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../../Utils/DxDefinesWrapper.h"

#include "../Enums/AttributeGranularity.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Class ------------------------------------

namespace nkGraphics
{
	struct MeshInputLayoutAttribute final
	{
		// Attributes
		nkMemory::String _semanticName ;
		unsigned int _bufferSlot = 0u ;
		unsigned int _byteOffset = -1 ;

		unsigned int _instanceStepRate = 1u ;

		unsigned int _arraySize = 1u ;

		FORMAT _format = R32G32B32A32_FLOAT ;
		ATTRIBUTE_GRANULARITY _granularity = ATTRIBUTE_GRANULARITY::PER_VERTEX ;

		// Functions
		// Constructors
		MeshInputLayoutAttribute () noexcept = default ;

		MeshInputLayoutAttribute (nkMemory::StringView semanticName) noexcept
		:	MeshInputLayoutAttribute ()
		{
			// Assign name
			_semanticName = semanticName ;
		}

		MeshInputLayoutAttribute (nkMemory::StringView semanticName, FORMAT format) noexcept
		:	MeshInputLayoutAttribute (semanticName)
		{
			_format = format ;
		}
	} ;
}